package w83b.w83bOperacionesPaso.w83bListados.w83bDelegados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bListadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaLibroDelegadosIncompletosExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bDelegadosIncompletos.xls";
		InputStream inputStream = W83bTablaLibroDelegadosIncompletosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaLibroIncompletos = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bClsTrazas.trazaDebug(null, "listaLibroIncompletos::::" + listaLibroIncompletos.size());
        W83bListadosBean listadoBean = (W83bListadosBean)contexto.get("w83bListadosBean");
       
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provinciaUs = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;

         
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)3);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        cell = row.getCell((short)5); 
        sheet.addMergedRegion(new Region((short)4,(short)5,(short)4,(short)6));//NOPMD
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provinciaUs)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provinciaUs)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provinciaUs)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provinciaUs)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)3);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)5); 
        sheet.addMergedRegion(new Region((short)6,(short)5,(short)6,(short)6));//NOPMD
        cell.setCellValue(tituloImagenEs.toString());
        
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)11); 
        
        cell = row.createCell((short)2);
        if(StringUtils.isNotEmpty(listadoBean.getDescTerritorio())){
        	cell.setCellValue(listadoBean.getDescTerritorio().toUpperCase());
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.createCell((short)4); 
        sheet.addMergedRegion(new Region((short)11,(short)4,(short)11,(short)5));//NOPMD
        String num=listadoBean.getNumActaDesde();
        if(StringUtils.isEmpty(listadoBean.getNumActaDesde())){
			num = "000000";
		}else if(6>listadoBean.getNumActaDesde().length()){
			for(int i = listadoBean.getNumActaDesde().length(),size = 6;i<size;i++){
				num = "0"+num;//NOPMD
			}
		}
        
        if(StringUtils.isNotEmpty(listadoBean.getTerritorioDesde()) && StringUtils.isNotEmpty(listadoBean.getAnyoDesde())){
        	cell.setCellValue(listadoBean.getTerritorioDesde()+"/"+listadoBean.getAnyoDesde()+"/"+num);
        }
        
        cell = row.createCell((short)9);
        sheet.addMergedRegion(new Region((short)11,(short)9,(short)11,(short)10));//NOPMD
        num=listadoBean.getNumActaHasta();
        if(StringUtils.isEmpty(listadoBean.getNumActaHasta())){
			num = "000000";
		}else if(6>listadoBean.getNumActaHasta().length()){
			for(int i = listadoBean.getNumActaHasta().length(),size = 6;i<size;i++){
				num = "0"+num;//NOPMD
			}
		}
        if(StringUtils.isNotEmpty(listadoBean.getTerritorioHasta()) && StringUtils.isNotEmpty(listadoBean.getAnyoHasta())){
        	cell.setCellValue(listadoBean.getTerritorioHasta()+"/"+listadoBean.getAnyoHasta()+"/"+num);
        }

    	
    	W83bListadosBean incompletos=new W83bListadosBean();
    	int p=0;
    	 for(int i=0;i<listaLibroIncompletos.size();i++){
        	incompletos=(W83bListadosBean)listaLibroIncompletos.get(i);
        	//if(incompletos.isIncompleto()){
	        	row = sheet.createRow((short)15+p); // Creacin de la fila 1
	        	
	        	cell = row.createCell((short)1); 
	        	if(StringUtils.isNotEmpty(incompletos.getActa())){
	        		cell.setCellValue(incompletos.getTerritorio()+"/"+incompletos.getAnyoActa()+"/"+W83bUtilidades.rellenarCaracter(incompletos.getActa(), String.valueOf(W83bClsConstantes.ZERO), 6, true));
	        	}
	        	
	        	
	        	cell = row.createCell((short)2); 
	        	if(StringUtils.isNotEmpty(incompletos.getNumRegistro())){
	        		cell.setCellValue(incompletos.getNumRegistro());
	        	}
	        	
	        	cell = row.createCell((short)3); 
	        	sheet.addMergedRegion(new Region((short)15+p,(short)3,(short)15+p,(short)6));//NOPMD
	        	if(StringUtils.isNotEmpty(incompletos.getRazon())){
	        		cell.setCellValue(incompletos.getRazon());
	        	}
	        	
	        	cell = row.createCell((short)7); 
	        	if(StringUtils.isNotEmpty(incompletos.getNumelectores())){
	        		cell.setCellValue(W83bUtilidades.numero(incompletos.getNumelectores()));
	        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        	}
	        	
	        	cell = row.createCell((short)8); 
	        	if(StringUtils.isNotEmpty(incompletos.getMaximoDelegados())){
	        		cell.setCellValue(W83bUtilidades.numero(incompletos.getMaximoDelegados()));
	        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        	}
	        	else{
	        		cell.setCellValue(W83bClsConstantes.ZERO);
	        	}
	        	
	        	cell = row.createCell((short)9); 
	        	if(StringUtils.isNotEmpty(incompletos.getDelegadosHombres())){
	        		cell.setCellValue(W83bUtilidades.numero(incompletos.getDelegadosHombres()));
	        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        	}
	        	else{
	        		cell.setCellValue(W83bClsConstantes.ZERO);
	        	}
	        	
	        	cell = row.createCell((short)10); 
	        	if(StringUtils.isNotEmpty(incompletos.getDelegadosMujeres())){
	        		cell.setCellValue(W83bUtilidades.numero(incompletos.getDelegadosMujeres()));
	        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        	}
	        	else{
	        		cell.setCellValue(W83bClsConstantes.ZERO);
	        	}
	        	
	        	p++;
        	//}
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoDelegadosIncompletos.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle styleDerechaNumeroFormateado(W83bUtilidadesExcel excel){
		return excel.styleDerechaNumeroFormateado;			
		
	}
}
